<?php

namespace Modules\Flowmaker\Models\Nodes;

use Illuminate\Support\Facades\Log;
use Modules\Flowmaker\Models\Contact;
use Modules\Flowmaker\Models\ContactState;

class End extends Node
{
    // public function process($message, $data)
    // {
    //     Log::info('Processing message in end node, clearing contact state');
    //     $contact = Contact::find($data['contact_id']);
    //     $contact->clearAllContactState($this->flow_id);
    //     Log::info('Contact state cleared');

    //     return [
    //         'success' => true
    //     ];
    // }
    
     public function process($message, $data)
    {
        // Reset flow state when flow ends
        $contact = $data->contact;
        if ($contact) {
            // Clear all state for this flow (current_node and variables)
            ContactState::where('contact_id', $contact->id)
                ->where('flow_id', $this->flow_id)
                ->delete();
            // Reset current flow pointer
            $contact->resetFlowState();
            Log::info('Flow completed, state reset', [
                'contact_id' => $contact->id,
                'flow_id' => $this->flow_id
            ]);
        }
        
        // Original end node logic
        return null;
    }

    protected function getNextNodeId($param=null)
    {
        // End node has no next node to process
        return null;
    }
}
